( function( $ ) {
    'use strict';

    /* rtl check */
    function rtl_owl(){
    if ($('body').hasClass("rtl")) {
        return true;
    } else {
        return false;
    }};

    /* rtl for Isotop */
    function rtl_isotop(){
        if ($('body').hasClass("rtl")) {
            return false;
        } else {
            return true;
    }};

    /* OT Custom Nav Arrow Slider */
    var otNavText = [
        '<svg viewBox="0 0 103 16" xmlns="http://www.w3.org/2000/svg"><path d="M102.707 8.70711C103.098 8.31658 103.098 7.68342 102.707 7.29289L96.3431 0.928932C95.9526 0.538408 95.3195 0.538408 94.9289 0.928932C94.5384 1.31946 94.5384 1.95262 94.9289 2.34315L100.586 8L94.9289 13.6569C94.5384 14.0474 94.5384 14.6805 94.9289 15.0711C95.3195 15.4616 95.9526 15.4616 96.3431 15.0711L102.707 8.70711ZM0 9H102V7H0L0 9Z"/></svg>',
        '<svg viewBox="0 0 103 16" xmlns="http://www.w3.org/2000/svg"><path d="M102.707 8.70711C103.098 8.31658 103.098 7.68342 102.707 7.29289L96.3431 0.928932C95.9526 0.538408 95.3195 0.538408 94.9289 0.928932C94.5384 1.31946 94.5384 1.95262 94.9289 2.34315L100.586 8L94.9289 13.6569C94.5384 14.0474 94.5384 14.6805 94.9289 15.0711C95.3195 15.4616 95.9526 15.4616 96.3431 15.0711L102.707 8.70711ZM0 9H102V7H0L0 9Z"/></svg>'
    ];

    /* --------------------------------------------------
     * Carousel Outside
     * --------------------------------------------------*/
    
    function carouselOutside(){
        var otSliderOutside = $('.ot-slider.--outside');
        if (otSliderOutside.length > 0 ) {
            otSliderOutside.each(function() {
                var screen_width = $(window).width();
                if ( screen_width > 1200 ) {                
                    var margin = screen_width - 1170;                
                } else {
                    var margin = 0;
                }
                $(this).css( 'margin-right', -margin/2 );
            });
        }
        return false;
    }
    var otOutside = function () {
        carouselOutside();
        $(window).on( 'resize', function() {
            carouselOutside();
        });
    };

    /* --------------------------------------------------
     * Gallery Outside
     * --------------------------------------------------*/
    function galleryOutside(){
        var otGalleryOutsideWrap = $('.ot-image-gallery.--outside');
        if (otGalleryOutsideWrap.length > 0 ) {
            otGalleryOutsideWrap.each( function(){
                var screen_width = $(window).width();
                if ( screen_width > 1200 ) {                
                    var margin = screen_width - 1170;                
                } else {
                    var margin = 0;
                }
                $(this).css( 'margin-right', -margin/2 );
            })
        }
        return false;
    }

    var otGalleryOutside = function () {
        galleryOutside();
        $(window).on( 'resize', function() {
            galleryOutside();
        });
    };

    /* --------------------------------------------------
     * Custom Navigation Events
     * --------------------------------------------------*/
    function customNav(selector){
        var customNav   = selector.find('.custom-nav'),
            otOwl       = selector.find('.owl-carousel');
        if( customNav.length > 0 ){
            /* Go to the next item */
            customNav.find('.owl-next').on("click", function () {
                otOwl.trigger('next.owl.carousel', [300]);
            });
            /* Go to the previous item */
            customNav.find('.owl-prev').on("click", function () {
                otOwl.trigger('prev.owl.carousel', [300]);
            });  
        }
        return false;
    }

    /* --------------------------------------------------
     * Progress bar
     * --------------------------------------------------*/
    function lineProgress() {
        $('.ot-progress-line:not([data-processed])').each(function() {
            var bar = $(this),
                line = bar.find(".ot-progress-bar"),
                progressEnd = bar.data('percent'),
                percent = bar.find('.ot-progress-percent');
            var scrollTop = $(document).scrollTop() + $(window).height();

            if ( scrollTop >  bar.offset().top +  bar.height() ) {
                bar.attr("data-processed", "true");
                line.css("width", (bar.outerWidth() * (progressEnd / 100)) + "px");

                for (var i = 0; i <= 50; i++) {
                    (function (count) {
                        setTimeout(function () {
                            percent.html(Math.round((progressEnd / 50) * count) + "%");
                        }, 30 * count);
                    })(i);
                }
            }
        });
    };

    /* Progress bar size */
    function lineProgressSize() {
        $('.ot-progress-line[data-processed]').each(function () {
            var bar = $(this);
            var line = bar.find(".ot-progress-bar");
            var progressEnd = parseInt(bar.data('percent'));

            line.css("width", (bar.outerWidth() * (progressEnd / 100)) + "px");
        });
    }

    /* ------------------------------------------
     * Circle Progress
     * ----------------------------------------*/

    function circleProgress() {
        $('.ot-progress-circle:not([data-processed])').each(function() {
            var circle    = $(this),
                bar_color = circle.data('color'),
                bar_hei   = circle.data('height'),
                bar_size  = circle.data('size');
            var scrollTop = $(document).scrollTop() + $(window).height();
            if ( scrollTop >  circle.offset().top +  circle.height() ) {
                circle.attr("data-processed", "true");
                circle.find('.ot-progress-circle__inner').easyPieChart({
                    barColor: bar_color,
                    trackColor: false,
                    scaleColor: false,
                    lineCap: 'square',
                    lineWidth: bar_hei,
                    size: bar_size,
                    animate: 1000,
                    onStart: $.noop,
                    onStop: $.noop,
                    /*easing: 'easeInOut',*/
                    onStep: function(from, to, percent) {
                        $(this.el).find('.ot-progress-percent').text(Math.round(percent) + '%');
                    }
                });
            }
        });
    };
    
    var progressBar = function () {
        lineProgress();
        circleProgress();
    };

    /* --------------------------------------------------
    * Switcher
    * --------------------------------------------------*/
    var otSwitcher = function ($scope, $) {
        $('section.yearly').hide();
        $scope.find('.ot-switcher').each( function () {
            var selector  = $(this);
            selector.find('span').on( 'click', function() {
                var parent = $(this).parents('.elementor-top-section');
                selector.find('span').removeClass('active');
                $(this).addClass('active');
                if( $(this).hasClass('l-switch') ){
                    parent.find('section.yearly').hide();
                    parent.find('section.monthly').show();
                }else{
                    parent.find('section.monthly').hide();
                    parent.find('section.yearly').show();
                }
            });
        });
    }

    /* --------------------------------------------------
     * Compare Pricing Table ( For Click in Mobile )
     * --------------------------------------------------*/
    var compareTable = function ($scope, $) {
        $($scope.find(".ot-cpt-heading")[0]).addClass("active");
        $scope.find("ul").on("click", "li", function () {
            var pos = $(this).index() + 2;
            $scope.find("tr").find('td:not(:eq(0))').hide();
            $scope.find('td:nth-child(' + pos + ')').css('display', 'table-cell');
            $scope.find("tr").find('th:not(:eq(0))').hide();
            $scope.find('li').removeClass('active');
            $(this).addClass('active');
        });
    };

    /* --------------------------------------------------
    * Tabs
    * --------------------------------------------------*/
    var customTabs = function ($scope, $) {

        $scope.find('.ot-tabs').each(function() {
            var selector = $(this),
                tabs     = selector.find('.ot-tabs__heading li'),
                content  = selector.find('.ot-tabs__content');
            tabs.first().addClass('current');
            content.first().addClass('current');

            tabs.on( 'click', function(){
                var tab_id = $(this).attr('data-tab');
                $(this).siblings().removeClass('current');
                $(this).parents('.ot-tabs').find('.ot-tabs__content').removeClass('current');
                $(this).addClass('current');
                $("#"+tab_id).addClass('current');
            });
        });
    };

    /* --------------------------------------------------
     * counter
     * --------------------------------------------------*/
    var otCounter = function () {
        $('.ot-counter[data-counter]').each( function () {
            var scrollTop   = $(document).scrollTop() + $(window).height();
            var counter     = $(this).find('span.ot-counter__num'),
                countTo     = counter.attr('data-to'),
                during      = parseInt( counter.attr('data-time') );

            if ( scrollTop > counter.offset().top + counter.height() ) {
                $(this).removeAttr('data-counter');
                $({
                    countNum: counter.text()
                }).animate({
                    countNum: countTo
                },
                {
                    duration: during,
                    easing: 'swing',
                    step: function() {
                        counter.text(Math.floor(this.countNum));
                    },
                    complete: function() {
                        counter.text(this.countNum);
                    }
                });
            }
        });
    };

    /* --------------------------------------------------
    * Accordions
    * --------------------------------------------------*/
    var customAccordions = function ($scope, $) {
        $scope.find('.ot-accordions-wrapper').each( function () {
            var selector = $(this),
                content = selector.find('.ot-acc-item__content'),
                header  = selector.find('.ot-acc-item__title');

            header.off("click");

            header.each(function(){
                if ($(this).data('default') == 'yes') {
                    $(this).next().addClass('active').slideDown(300);
                    $(this).parent().addClass('current');
                }
            });

            header.on('click', function(e){
                e.preventDefault();
                var $this = $(this);

                $this.next().toggleClass('active').slideToggle(300);
                $this.parent().toggleClass('current');
                content.not($this.next()).slideUp(300);
                header.not($this).parent().removeClass('current');
            });
        });
    };

    /* --------------------------------------------------
     * Client Logo Carousel
     * --------------------------------------------------*/
    var clientLogoCarousel = function ($scope, $) {
        $scope.find('.ot-client-logo-slider').each( function () {
            var selector     = $(this),
                sliderSettings = selector.data('slider_options'),
                dotsClass = sliderSettings.dots_style === 'classic' ? 'owl-dots ot-dots-classic' : 'owl-dots ot-dots-custom';
                
            selector.find('.owl-carousel').owlCarousel({
                rtl: rtl_owl(),
                autoplay: 'yes' === sliderSettings.autoplay,
                autoplayTimeout: parseInt(sliderSettings.autoplay_time_out),
                loop: 'yes' === sliderSettings.loop,
                responsiveClass:true,
                dotsClass: String(dotsClass),
                dots: sliderSettings.dots,
                nav: sliderSettings.arrows,
                autoplayHoverPause: true,
                navText: otNavText,
                responsive : {
                    0 : {
                        items: parseInt(sliderSettings.slides_show_mobile),
                        margin: parseInt(sliderSettings.margin_mobile),
                    },
                    768 : {
                        items: parseInt(sliderSettings.slides_show_tablet),
                        margin: parseInt(sliderSettings.margin_tablet),
                    },
                    1024 : {
                        items: parseInt(sliderSettings.slides_show_desktop),
                        margin: parseInt(sliderSettings.margin_desktop),
                    }
                }
            });
        });
    };

    /* --------------------------------------------------
     * Image Carousel
     * --------------------------------------------------*/
    var imageCarousel = function ($scope, $) {
        otOutside();
        $scope.find('.ot-image-slider').each( function () {
            var selector     = $(this),
                sliderSettings = selector.data('slider_options'),
                dotsClass = sliderSettings.dots_style === 'classic' ? 'owl-dots ot-dots-classic' : 'owl-dots ot-dots-custom';
                
            selector.find('.owl-carousel').owlCarousel({
                rtl: rtl_owl(),
                autoplay: 'yes' === sliderSettings.autoplay,
                autoplayTimeout: parseInt(sliderSettings.autoplay_time_out),
                loop: 'yes' === sliderSettings.loop,
                autoWidth: 'yes' === sliderSettings.auto_width,
                responsiveClass:true,
                dotsClass: String(dotsClass),
                dots: sliderSettings.dots,
                nav: sliderSettings.arrows,
                autoplayHoverPause: true,
                navText: otNavText,
                responsive : {
                    0 : {
                        items: parseInt(sliderSettings.slides_show_mobile),
                        margin: parseInt(sliderSettings.margin_mobile),
                    },
                    768 : {
                        items: parseInt(sliderSettings.slides_show_tablet),
                        margin: parseInt(sliderSettings.margin_tablet),
                    },
                    1024 : {
                        items: parseInt(sliderSettings.slides_show_desktop),
                        margin: parseInt(sliderSettings.margin_desktop),
                    }
                }
            });
        });
    };

    /* --------------------------------------------------
     * Testimonial Carousel
     * --------------------------------------------------*/
    var testimonialCarousel = function ($scope, $) {
        otOutside();
        $scope.find('.ot-testimonial-slider').each( function () {
            var selector     = $(this),
                sliderSettings = selector.data('slider_options'),
                dotsClass = sliderSettings.dots_style === 'classic' ? 'owl-dots ot-dots-classic' : 'owl-dots ot-dots-custom';
                
            selector.find('.owl-carousel').owlCarousel({
                rtl: rtl_owl(),
                autoplay: 'yes' === sliderSettings.autoplay,
                autoplayTimeout: parseInt(sliderSettings.autoplay_time_out),
                loop: 'yes' === sliderSettings.loop,
                animateOut: 'yes' === sliderSettings.fade ? 'fadeOut' : '',
                responsiveClass:true,
                dotsClass: String(dotsClass),
                dots: sliderSettings.dots,
                nav: sliderSettings.arrows,
                autoplayHoverPause: true,
                navText: otNavText,
                responsive : {
                    0 : {
                        items: parseInt(sliderSettings.slides_show_mobile),
                        margin: parseInt(sliderSettings.margin_mobile),
                    },
                    768 : {
                        items: parseInt(sliderSettings.slides_show_tablet),
                        margin: parseInt(sliderSettings.margin_tablet),
                    },
                    1024 : {
                        items: parseInt(sliderSettings.slides_show_desktop),
                        margin: parseInt(sliderSettings.margin_desktop),
                    }
                }
            });
        });
    };

    /* --------------------------------------------------
     * Team Carousel
     * --------------------------------------------------*/
    var teamCarousel = function ($scope, $) {
        otOutside();
        $scope.find('.ot-team-slider').each( function () {
            var selector     = $(this),
                sliderSettings = selector.data('slider_options'),
                dotsClass = sliderSettings.dots_style === 'classic' ? 'owl-dots ot-dots-classic' : 'owl-dots ot-dots-custom';
                
            selector.find('.owl-carousel').owlCarousel({
                rtl: rtl_owl(),
                autoplay: 'yes' === sliderSettings.autoplay,
                autoplayTimeout: parseInt(sliderSettings.autoplay_time_out),
                loop: 'yes' === sliderSettings.loop,
                responsiveClass:true,
                dotsClass: String(dotsClass),
                dots: sliderSettings.dots,
                nav: sliderSettings.arrows,
                autoplayHoverPause: true,
                navText: otNavText,
                responsive : {
                    0 : {
                        items: parseInt(sliderSettings.slides_show_mobile),
                        margin: parseInt(sliderSettings.margin_mobile),
                    },
                    768 : {
                        items: parseInt(sliderSettings.slides_show_tablet),
                        margin: parseInt(sliderSettings.margin_tablet),
                    },
                    1024 : {
                        items: parseInt(sliderSettings.slides_show_desktop),
                        margin: parseInt(sliderSettings.margin_desktop),
                    }
                }
            });
        });
        customNav($scope);
    };

    /* --------------------------------------------------
     * Service Item Carousel
     * --------------------------------------------------*/
    var serviceItemCarousel = function ($scope, $) {
        otOutside();
        $scope.find('.ot-service-slider').each( function () {
            var selector     = $(this),
                sliderSettings = selector.data('slider_options'),
                dotsClass = sliderSettings.dots_style === 'classic' ? 'owl-dots ot-dots-classic' : 'owl-dots ot-dots-custom';
                
            selector.find('.owl-carousel').owlCarousel({
                rtl: rtl_owl(),
                autoplay: 'yes' === sliderSettings.autoplay,
                autoplayTimeout: parseInt(sliderSettings.autoplay_time_out),
                loop: 'yes' === sliderSettings.loop,
                responsiveClass:true,
                dotsClass: String(dotsClass),
                dots: sliderSettings.dots,
                nav: sliderSettings.arrows,
                autoplayHoverPause: true,
                navText: otNavText,
                responsive : {
                    0 : {
                        items: Number(sliderSettings.slides_show_mobile),
                        margin: parseInt(sliderSettings.margin_mobile),
                    },
                    768 : {
                        items: Number(sliderSettings.slides_show_tablet),
                        margin: parseInt(sliderSettings.margin_tablet),
                    },
                    1200 : {
                        items: Number(sliderSettings.slides_show_desktop),
                        margin: parseInt(sliderSettings.margin_desktop),
                    }
                }
            });
        });
        customNav($scope);
    };

    /* --------------------------------------------------
    * blog carousel
    * --------------------------------------------------*/
    var blogCarousel = function ($scope, $) {
        $scope.find('.ot-blog-slider').each( function () {
            var selector     = $(this),
                sliderSettings = selector.data('slider_options'),
                dotsClass = sliderSettings.dots_style === 'classic' ? 'owl-dots ot-dots-classic' : 'owl-dots ot-dots-custom';
                
            selector.find('.owl-carousel').owlCarousel({
                rtl: rtl_owl(),
                autoplay: 'yes' === sliderSettings.autoplay,
                autoplayTimeout: parseInt(sliderSettings.autoplay_time_out),
                loop: 'yes'   === sliderSettings.loop,
                responsiveClass:true,
                dotsClass: String(dotsClass),
                dots: sliderSettings.dots,
                nav: sliderSettings.arrows,
                autoplayHoverPause: true,
                navText: otNavText,
                responsive : {
                    0 : {
                        items: parseInt(sliderSettings.slides_show_mobile),
                        margin: parseInt(sliderSettings.margin_mobile),
                    },
                    768 : {
                        items: parseInt(sliderSettings.slides_show_tablet),
                        margin: parseInt(sliderSettings.margin_tablet),
                    },
                    1024 : {
                        items: parseInt(sliderSettings.slides_show_desktop),
                        margin: parseInt(sliderSettings.margin_desktop),
                    }
                }
            });
        });
    };

    /* --------------------------------------------------
    * projects carousel
    * --------------------------------------------------*/
    var projectsCarousel = function ($scope, $) {
        otOutside();
        $scope.find('.ot-project-slider').each( function () {
            var selector     = $(this),
                sliderSettings = selector.data('slider_options'),
                dotsClass = sliderSettings.dots_style === 'classic' ? 'owl-dots ot-dots-classic' : 'owl-dots ot-dots-custom';
            selector.find('.owl-carousel').owlCarousel({
                rtl: rtl_owl(),
                autoplay: 'yes' === sliderSettings.autoplay,
                autoplayTimeout: parseInt(sliderSettings.autoplay_time_out),
                loop: 'yes'   === sliderSettings.loop,
                responsiveClass:true,
                dotsClass: String(dotsClass),
                dots: sliderSettings.dots,
                nav: sliderSettings.arrows,
                autoplayHoverPause: true,
                navText: otNavText,
                responsive : {
                    0 : {
                        items: parseInt(sliderSettings.slides_show_mobile),
                        margin: parseInt(sliderSettings.margin_mobile),
                    },
                    768 : {
                        items: parseInt(sliderSettings.slides_show_tablet),
                        margin: parseInt(sliderSettings.margin_tablet),
                    },
                    1024 : {
                        items: parseInt(sliderSettings.slides_show_desktop),
                        margin: parseInt(sliderSettings.margin_desktop),
                    }
                }
            });
            /* popup gallery */
            if( selector.hasClass('img-popup') ){
                $('.img-popup').lightGallery({
                    selector: '.projects-thumbnail',
                    share: false,
                    pager: false,
                    thumbnail: false
                });
            }
        });
    };

    /* --------------------------------------------------
    * Countdown for coming soon
    * --------------------------------------------------*/
    var countDown = function($scope, $){
        $scope.find('.ot-countdown').each( function(){
            var selector = $(this),
                date     = selector.data('date'),
                zone     = selector.data('zone'),
                day      = selector.data('day'),
                days     = selector.data('days'),
                hour     = selector.data('hour'),
                hours    = selector.data('hours'),
                min      = selector.data('min'),
                mins     = selector.data('mins'),
                second   = selector.data('second'),
                seconds  = selector.data('seconds');
            selector.countdown({
                date: date,
                offset: zone,
                day: day,
                days: days,
                hour: hour,
                hours: hours,
                minute: min,
                minutes: mins,
                second: second,
                seconds: seconds
            }, function () {
                alert('Done!');
            });
        });
    };

    /* --------------------------------------------------
    * image gallery
    * --------------------------------------------------*/
    var imageGallery = function ($scope, $) {
        otGalleryOutside();
        $scope.find('.ot-image-gallery').each( function(){
            var selector = $(this),
                popup   = selector.find('.gallery-icon > a');
            popup.append('<span class="overlay"><i class="ot-flaticon-loupe"></i></span>');
            selector.lightGallery({
                selector: popup,
                share: false,
                pager: false,
            });
        });
    };

    /* --------------------------------------------------
    * Portfolio filter isotope
    * --------------------------------------------------*/
    var otPortfolioFilter = function () {
        function updateFilter() {
            $('.project_filters a').each(function() {
                var data_filter = this.getAttribute('data-filter');
                var num = $(this)
                    .closest('.project-filter-wrapper')
                    .find('.project-item')
                    .filter(data_filter).length;
                $(this)
                    .find('sup')
                    .text( num );
            });
        }
        $('.projects-grid').each( function(){
            var $container = $(this); 
            $container.imagesLoaded(function() {
                $container.isotope({ 
                    itemSelector : '.project-item', 
                    animationEngine : 'css',
                    masonry: {
                        columnWidth: '.grid-sizer'
                    },
                    isOriginLeft: rtl_isotop(),
                });
                $container.isotope("layout");
            });
    
            var $optionSets  = $(this).closest('.project-filter-wrapper').find('.project_filters'),
                $optionLinks = $optionSets.find('a');
    
            $optionLinks.on('click', function(){
                var $this = $(this);
    
                if ( $this.hasClass('selected') ) {
                    return false;
                }
                var $optionSet = $this.parents('.project_filters');
                    $optionSet.find('.selected').removeClass('selected');
                    $this.addClass('selected');
    
                var selector = $(this).attr('data-filter');
                $container.isotope({ 
                    filter: selector 
                });
                return false;
            });
            /* popup gallery */
            if( $container.hasClass('img-popup') ){
                $('.img-popup').lightGallery({
                    selector: '.projects-thumbnail',
                    share: false,
                    pager: false,
                    thumbnail: false
                });
            }
            /* count filters */
            updateFilter();
        });
    };

    function otIsotope() {
        $('.projects-grid').each(function () {
            var $isotopeWrap = $(this);
            var properties = {
                itemSelector : '.project-item',
                animationEngine : 'css',
                layoutMode: 'masonry',
                percentPosition: true,
                masonry: {
                    columnWidth: '.grid-sizer'
                },
                isOriginLeft: rtl_isotop(),
            };
            $isotopeWrap.imagesLoaded(function() {
                $isotopeWrap.isotope(properties);
                $isotopeWrap.isotope("layout");
            });
            otIsotopeFilterHandler(this);
        });
    }

    function otIsotopeFilterHandler(self){
        var filterBtn = $(self).closest('.project-filter-wrapper').find('.project_filters a');

        /* Filter Counter */
        filterBtn.each(function() {
            var $this = $(this),
                num,
                data_filter = this.dataset.filter;

            num = $this
                .closest('.project-filter-wrapper')
                .find('.project-item')
                .filter(data_filter).length;

            $this.find('sup').text( num );
        });

        /* Filter Handler */
        filterBtn.on('click', function (e) {
            e.preventDefault();

            var $this = $(this);
            if ( $this.hasClass('selected') ) {
                return false;
            }
            $this.addClass('selected').parent().siblings().find('a').removeClass('selected');

            var dataFilter  = $this.attr('data-filter'),
                isotopeWrap = $this.closest('.project-filter-wrapper').find('.projects-grid');
            isotopeWrap.isotope({ 
                filter: dataFilter 
            });
            return false;
        });

        /* Popup Gallery */
        if( $(self).hasClass('img-popup') ){
            $('.img-popup').lightGallery({
                selector: '.projects-thumbnail',
                share: false,
                pager: false,
                thumbnail: false
            });
        }
    }

    /* --------------------------------------------------
    * Image Before After
    * --------------------------------------------------*/
    var beforeAfter = function ( $scope , $ ) {
        $scope.find('.twentytwenty-container').each( function(){
            var $selector     = $(this),
                orientation     = $selector.data('orientation'),
                before      = $selector.data('before'),
                after       = $selector.data('after'),
                before_size     = $selector.data('bsize');      
            $selector.twentytwenty({        
                default_offset_pct: before_size, 
                orientation: orientation, 
                before_label: before, 
                after_label: after, 
                no_overlay: false, 
                move_slider_on_hover: false, 
                move_with_handle_only: true, 
                click_to_move: true,
            });     
        }); 
    };

    /* --------------------------------------------------
    * handle after scroll/load/resize
    * --------------------------------------------------*/
    $(window).on('scroll', function() {
        lineProgress();
        circleProgress();
        otCounter();
    });
    $(window).on('load', function () {
        lineProgress();
        circleProgress();
        otCounter();
        /*otPortfolioFilter();*/
        otIsotope();
    });
    $(window).on('resize', function () {
        lineProgressSize();
    });

    /**
     * Elementor JS Hooks
     */
    $(window).on("elementor/frontend/init", function () {
        if (window.elementorFrontend.isEditMode()) {
            
            /* Portfolio filter isotop */
            window.elementorFrontend.hooks.addAction(
                "frontend/element_ready/ot-portfolio-grid.default",
                function ($scope) {
                    otIsotope();
                }
            );

            /* Portfolio Scattered */
            window.elementorFrontend.hooks.addAction(
                "frontend/element_ready/ot-portfolio-scattered.default",
                function ($scope) {
                    otIsotope();
                }
            );
        }

        /* Progress bar */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-progress.default",
            progressBar
        );

        /* Switcher */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-switcher.default",
            otSwitcher
        );

        /* Compare pricing table */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-comparetable.default",
            compareTable
        );

        /* Custom tabs */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-tabs.default",
            customTabs
        );

        /* Client logo carousel */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-client-logos.default",
            clientLogoCarousel
        );

        /* Image carousel */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-image-carousel.default",
            imageCarousel
        );

        /* Counter */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-counter.default",
            otCounter
        );

        /* Custom accordions */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-accordions.default",
            customAccordions
        );

        /* Testimonial carousel */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-testimonials.default",
            testimonialCarousel
        );

        /* Testimonial carousel vertical*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-testimonials-vertical.default",
            testimonialCarousel
        );

        /* Team carousel */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-team-carousel.default",
            teamCarousel
        );

        /* Team carousel with heading */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-team-carousel-with-heading.default",
            teamCarousel
        );

        /* Service Item Carousel with heading */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-servive-item-carousel.default",
            serviceItemCarousel
        );

        /* Service Item Carousel 2 */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-servive-carousel_2.default",
            serviceItemCarousel
        );

        /* Blog carousel */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-post-carousel.default",
            blogCarousel
        );

        /* Countdown */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-countdown.default",
            countDown
        );

        /* Gallery */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-image-gallery.default",
            imageGallery
        );

        /* Portfolio filter isotop */
        /*elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-portfolio-grid.default",
            otPortfolioFilter
        );*/

        /* Portfolio Scattered */
        /*elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-portfolio-scattered.default",
            otPortfolioFilter
        );*/


        /* projects carousel */
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-portfolio-carousel.default",
            projectsCarousel
        );

        /*Image Before After*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-before-after.default",
            beforeAfter
        );

    });


} )( jQuery );