(function($) {
    "use strict";
    
    $(document).ready( function() {
        
        /* --------------------------------------------------
        * side panel
        * --------------------------------------------------*/
        var element = $('#panel-btn'),
        sidebar = $('#side-panel');
      
        function panel_handler() {
            var isActive = !element.hasClass('active');
      
            element.toggleClass('active', isActive);
            sidebar.toggleClass('side-panel-open', isActive);
            $('body').toggleClass('side-panel-active', isActive);
            return false;
        }
      
        $('#panel-btn, .side-panel-close, .panel-overlay').on('click', panel_handler);

        /* --------------------------------------------------
        * Function header bottom begin
        * --------------------------------------------------*/
        var headerBottom = $('section.header-bottom').parents('header');

        function otHeaderBottomLoad() {
            var mq = window.matchMedia("(min-width: 1025px)"),
                $document = $(document),
                header_height = parseInt(headerBottom.height(), 10),
                screen_height = parseInt($(window).height(), 10),
                header_mt = screen_height - header_height;

            window.addEventListener('scroll', function(e){
                if (mq.matches) {
                    var $document = $(document),
                        header_height = parseInt(headerBottom.height(), 10),
                        screen_height = parseInt($(window).height(), 10),
                        header_mt = screen_height - header_height;

                    if ($document.scrollTop() >= header_mt) {
                        headerBottom.css("position", "fixed");
                        headerBottom.css("top", "0");
                    } else if ($document.scrollTop() <= header_mt) {
                        headerBottom.css("position", "absolute");
                        headerBottom.css("top", header_mt);
                    }
                }
            });
            if (mq.matches) {
                headerBottom.css('position', 'absolute');
                headerBottom.css('top', header_mt);
            }
        }

        function otHeaderBottomResize() {
            var mq = window.matchMedia("(max-width: 1024px)");
            if (mq.matches) {
                headerBottom.css("position", "relative");
                headerBottom.css("top", "0");
            }
        }

        /* Function header bottom close */

        $(window).on('load', function () {
            if( headerBottom.length > 0 ){
                otHeaderBottomLoad();
            }
        });
        $(window).on('resize', function () {
            if( headerBottom.length > 0 ){
                otHeaderBottomResize();
            }
        });
    });
  
    /* --------------------------------------------------
    * toggle search
    * --------------------------------------------------*/
    var tgSearch  = function($scope, $){
        $scope.find('.octf-search').each( function(){
        var selector = $(this);
        selector.find('.toggle_search').on("click", function(){
            $(this).toggleClass( "active" );
            selector.find('.h-search-form-field').toggleClass('show');
            if ($(this).find('i').hasClass( "ot-flaticon-loupe" )) {
                $(this).find('i').removeClass( "ot-flaticon-loupe" ).addClass("ot-flaticon-close");
            }else{
                $(this).find('i').removeClass( "ot-flaticon-close" ).addClass("ot-flaticon-loupe");
            }
        });
      });
    };
  
    /* --------------------------------------------------
    * mobile menu
    * --------------------------------------------------*/
    var mmenuPanel  = function(){
        var element = $('#mmenu-toggle'),
            mmenu   = $('#mmenu-wrapper');
  
        function mmenu_handler() {
            var isActive = !element.hasClass('active');
  
            element.toggleClass('active', isActive);
            mmenu.toggleClass('mmenu-open', isActive);
            $('body').toggleClass('mmenu-active', isActive);
            return false;
        }
  
        $('#mmenu-toggle, .mmenu-close, .mmenu-overlay').on('click', mmenu_handler);
  
        $('.mmenu-wrapper li:has(ul)').prepend('<span class="arrow"><i class="ot-flaticon-arrow-point-to-right"></i></span>');
        $(".mmenu-wrapper .mobile_mainmenu > li span.arrow").on('click',function() {
            $(this).parent().find("> ul").stop(true, true).slideToggle()
            $(this).toggleClass( "active" ); 
        });
    };

    /* --------------------------------------------------
    * menu vertical
    * --------------------------------------------------*/
    var menuVertical = function($scope, $){
        if( $scope.find('.vertical-main-navigation').length ){
            $scope.find('.vertical-main-navigation').each( function(){
                var selector         = $(this),
                    itemHasChildren  = selector.find('> ul > li.menu-item-has-children > a'),
                    nItemHasChildren = selector.find('ul ul > li.menu-item-has-children > a');
                    
                itemHasChildren.on('click',function() {
                    itemHasChildren.parent().not($(this).parents('li.menu-item-has-children')).find('>ul').stop(true, true).slideUp();
                    nItemHasChildren.parent().find('>ul').stop(true, true).slideUp();
                    nItemHasChildren.removeClass('active');
                    itemHasChildren.not($(this)).removeClass('active');
                    $(this).parents('li.menu-item-has-children').find('>ul').stop(true, true).slideToggle();
                    $(this).toggleClass( 'active' );
                });

                nItemHasChildren.on('click',function() {
                    $(this).parents('sub-menu').eq(0).find('li.menu-item-has-children').not($(this).parents('li.menu-item-has-children').eq(0)).find('>ul').stop(true, true).slideUp();
                    $(this).parents('sub-menu').eq(0).find('li.menu-item-has-children').find('>a').not($(this)).removeClass('active');
                    $(this).parents('li.menu-item-has-children').eq(0).find('>ul').stop(true, true).slideToggle();
                    $(this).toggleClass( 'active' );
                });
            });
        }
    };

    /* --------------------------------------------------
    * Hamburger menu
    * --------------------------------------------------*/
    var hamburgerMenu = function($scope, $){
        $scope.find('.octf-menu-hamburger-area').each( function(){
            var selector         = $(this),
                btnToggle        = selector.find('.menu-hamburger-toggle'),
                menuHamburger    = selector.find('.octf-menu-hamburger'),
                menuOverlay      = selector.find('.menu-overlay'),
                btnClose         = menuHamburger.find('#menu-hamburger-close');

            function menu_hamburger_handler() {
                var isActive = !btnToggle.hasClass('active');
                btnToggle.toggleClass('active', isActive);
                menuHamburger.toggleClass('open-menu', isActive);
                $('body').toggleClass('side-menu-active', isActive);
                return false;
            }
            
            btnToggle.on('click', menu_hamburger_handler);
            btnClose.on('click', menu_hamburger_handler);
            menuOverlay.on('click', menu_hamburger_handler);
            document.addEventListener('keydown', function(event){
                if(event.key === "Escape" && $('body').hasClass('side-menu-active')){
                    menu_hamburger_handler();
                }
            });
        });
    };
  
    /**
    * Elementor JS Hooks
    */
     $(window).on("elementor/frontend/init", function () {
  
        /*toggle search*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/isearch.default",
            tgSearch
        );
  
        /*mmenu*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/imenu_mobile.default",
            mmenuPanel
        );

        /*menu vertical*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/imenu.default",
            menuVertical
        );

        /*menu hamburger*/
        elementorFrontend.hooks.addAction(
            "frontend/element_ready/ot-menu-hamburger.default",
            hamburgerMenu
        );
  
    });
  
})(jQuery);