<?php
/**
 * Template part for displaying widget Portfolio Grid
 *
 * @package Ronmi
 */
?>
<?php 
	$cates = get_the_terms( get_the_ID(), 'portfolio_cat' );
    $cate_id   = '';
    if ( ! is_wp_error( $cates ) && ! empty( $cates ) ) :
	    foreach ( $cates as $cate ) {
	        $cate_id .= 'portfolio-category-id-' . $cate->term_id . ' ';
	    }
	endif;
	$thumb = '';
	if ( function_exists('rwmb_meta') ) {
		$thumb = rwmb_meta('thumb_size');
	}

	$content_reverse = '';
	if( !empty($args['settings']['content_reverse']) ){
		$content_reverse = 'info-reverse';
	}
?>
<article class="project-item <?php echo esc_attr( $cate_id ); echo esc_attr( $thumb ); ?>">
	<div class="projects-box">
		<div class="projects-thumbnail" data-src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" data-sub-html="<?php the_title(); ?>">
			<?php if ( has_post_thumbnail() ) { ?>
			<a href="<?php the_permalink(); ?>">
				<?php
					$args['settings']['post_thumbnail'] = [
						'id' => get_post_thumbnail_id(),
					];
					$thumbnail_html = Elementor\Group_Control_Image_Size::get_attachment_image_html( $args['settings'], 'post_thumbnail' );
					echo $thumbnail_html;
				?>
			</a>
			<?php } ?>
			<span class="overlay">
				<i class="ot-flaticon-loupe"></i>
			</span>
		</div>
		<div class="portfolio-info <?php if( 'yes' === $args['settings']['info_width'] ) echo 'full-width'; ?>">
			<div class="portfolio-info-inner <?php echo esc_attr( $content_reverse ); ?>">
				<?php 
					if ( ! is_wp_error( $cates ) && ! empty( $cates ) ) :
						echo '<p class="portfolio-cates">';	 
						foreach ( $cates as $term ) {
							// The $term is an object, so we don't need to specify the $taxonomy.
							$term_link = get_term_link( $term );
							// If there was an error, continue to the next term.
							if ( is_wp_error( $term_link ) ) {
								continue;
							}
							// We successfully got a link. Print it out.
							echo '<a href="' . esc_url( $term_link ) . '">' . $term->name . '</a>';
						}
						
						echo '</p>';    
					endif; 
				?> 
				<h5><a class="title-link" href="<?php the_permalink(); ?>" data-src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" data-sub-html="<?php the_title(); ?>"><?php the_title(); ?></a></h5>
				
				<?php if( 'yes' === $args['settings']['is_exc'] && has_excerpt() ){ ?>
				<div class="portfolio-exc">
		            <?php echo the_excerpt(); ?>
		        </div>
		    	<?php } ?>
			</div>
		</div>
	</div>
</article>

