<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsCourseDetail extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Bdevs Elementor widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'bdevs-course-detail';
    }

    /**
     * Get widget title.
     *
     * Retrieve Bdevs Elementor widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Course Detail', 'bdevs-elementor' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Bdevs About widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-table';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Bdevs About widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'bdevs-elementor' ];
    }

    public function get_keywords() {
        return [ 'course detail' ];
    }

    public function get_script_depends() {
        return [ 'bdevs-elementor'];
    }

    // BDT Position
    protected function element_pack_position() {
        $position_options = [
            ''              => esc_html__('Default', 'bdevs-elementor'),
            'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
            'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
            'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
            'center'        => esc_html__('Center', 'bdevs-elementor') ,
            'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
            'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
            'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
            'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
            'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
        ];

        return $position_options;
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'section_content_heading',
            [
                'label' => esc_html__( 'Course Detail', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'tabs',
            [
                'label' => esc_html__( 'Course Tabs', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'icon',
                        'label'       => esc_html__( 'Icon:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is icon' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'title',
                        'label'       => esc_html__( 'Title:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is title' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_tab_1',
            [
                'label' => esc_html__( 'Tab 1', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'tabs_1_column',
            [
                'label' => esc_html__( 'Table Heading:', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'name',
                        'label'       => esc_html__( 'Name:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is name' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->add_control(
            'tabs_1_content',
            [
                'label' => esc_html__( 'Table Content:', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [ 
                    [
                        'name'        => 'action',
                        'label'     => esc_html__( 'Action', 'bdevs-elementor' ),
                        'type'      => Controls_Manager::SELECT,
                        'dynamic' => [ 'active' => true ],
                        'options'   => [
                            '1'  => esc_html__( 'Add New Cell', 'bdevs-elementor' ),
                            '2'  => esc_html__( 'Add New Row', 'bdevs-elementor' ),
                        ],
                        'default'   => '1',
                    ],
                    [
                        'name'        => 'name',
                        'label'       => esc_html__( 'Name:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is name' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'description',
                        'label'       => esc_html__( 'Description:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is description' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_2',
            [
                'label' => esc_html__( 'Tab 2', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'tabs_2_column',
            [
                'label' => esc_html__( 'Table Heading:', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'name',
                        'label'       => esc_html__( 'Name:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is name' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->add_control(
            'tabs_2_row',
            [
                'label' => esc_html__( 'Table Content:', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'fee',
                        'label'       => esc_html__( 'Fee:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is fee' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'amount',
                        'label'       => esc_html__( 'Amount:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is amount' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'fee_detail',
                        'label'       => esc_html__( 'Fee Detail:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is fee detail' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_tab_3',
            [
                'label' => esc_html__( 'Tab 3', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'tabs_3_column_1',
            [
                'label' => esc_html__( 'Column 1', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'tab3_title',
                        'label'       => esc_html__( 'Title:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is title' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'content',
                        'label'       => esc_html__( 'Content:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is content' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->add_control(
            'tabs_3_column_2',
            [
                'label' => esc_html__( 'Column 2', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'        => 'tab3_title',
                        'label'       => esc_html__( 'Title:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is title' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'content',
                        'label'       => esc_html__( 'Content:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is content' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        );
        $this->end_controls_section();
         $this->start_controls_section(
            'section_tab_4',
            [
                'label' => esc_html__( 'Tab 4', 'bdevs-elementor' ),
            ]   
        );
        $this->add_control(
            'teachers',
            [
                'label' => esc_html__( 'Teachers', 'bdevs-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name'    => 'team_image',
                        'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
                        'type'    => Controls_Manager::MEDIA,
                        'dynamic' => [ 'active' => true ],
                    ],
                    [
                        'name'        => 'team_name',
                        'label'       => esc_html__( 'Name:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is name' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'job',
                        'label'       => esc_html__( 'Job:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is job' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'text',
                        'label'       => esc_html__( 'Text:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'This is text' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'link_social_1',
                        'label'       => esc_html__( 'Link Social 1:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'social_1',
                        'label'       => esc_html__( 'Social 1:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'fa fa-twitter' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'link_social_2',
                        'label'       => esc_html__( 'Link Social 2:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'social_2',
                        'label'       => esc_html__( 'Social 2:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'fa fa-linkedin' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'link_social_3',
                        'label'       => esc_html__( 'Link Social 3:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( '#' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                    [
                        'name'        => 'social_3',
                        'label'       => esc_html__( 'Social 3:', 'bdevs-elementor' ),
                        'type'        => Controls_Manager::TEXT,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'fa fa-skype' , 'bdevs-elementor' ),
                        'label_block' => true,
                    ],
                ],
            ]
        ); 
        $this->end_controls_section();
        /** 
        *   Layout section 
        **/
        $this->start_controls_section(
            'section_content_layout',
            [
                'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
            ]
        );
        $this->add_responsive_control(
            'align',
            [
                'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
                'type'    => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
                        'icon'  => 'fa fa-align-justify',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
                'description'  => 'Use align to match position',
                'default'      => 'left',
            ]
        );
        $this->end_controls_section();

    }

    public function render() {
    $settings  = $this->get_settings_for_display();
    extract($settings); ?>  
    <!-- Start Course Details Tab -->
    <section class="details-tab">
      <div class="container">
        <div class="row">
          <div class="col-sm-12">
            <div class="bs-example bs-example-tabs" data-example-id="togglable-tabs">
              <ul class="nav nav-tabs course-tab" id="myTabs" role="tablist">
                <?php 
                $i=0;
                foreach ( $settings['tabs'] as $item ) : 
                $i++;
                ?>
                <li role="presentation" class="<?php if($i==1){echo 'active';} ?>"> 
                  <a href="#<?php if($i==1){echo 'curriculam';} elseif($i==2){echo 'schedule';} elseif($i==3){echo 'semester';} elseif($i==4){echo 'teachers';} ?>" id="<?php if($i==1){echo 'curriculam';} ?>-tab" role="tab" data-toggle="tab" aria-controls="<?php if($i==1){echo 'curriculam';} ?>" aria-expanded="true">
                    <?php if(isset($item['icon']) && $item['icon'] != ''){?> 
                    <span class="<?php print wp_kses_post($item['icon']); ?>"></span>
                    <?php } ?>
                    <?php if(isset($item['title']) && $item['title'] != ''){?> 
                    <div class="block"><?php print wp_kses_post($item['title']); ?></div>  
                    <?php } ?>
                  </a> 
                </li>
                <?php endforeach; ?>
              </ul>
              <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade active in" role="tabpanel" id="curriculam" aria-labelledby="curriculam-tab">
                  <div class="table-responsive">
                    <table class="table course-table table-bordered">
                      <thead>
                        <tr>
                            <?php foreach ( $settings['tabs_1_column'] as $column1 ) : ?>
                            <th><?php print wp_kses_post($column1['name']); ?></th>
                            <?php endforeach; ?>
                        </tr>
                      </thead>
                      <tbody>
                        <tr>
                            <?php foreach ( $settings['tabs_1_content'] as $tab_1_item ) : ?>
                            <?php if( wp_kses_post($tab_1_item['action']) == '1'): ?>
                            <td><div class="table-col1">
                                <div class="lecture-txt">
                                <?php print wp_kses_post($tab_1_item['name']); ?> 
                                </div>
                                <?php print wp_kses_post($tab_1_item['description']); ?> 
                                </div>
                            </td> 
                            <?php elseif( wp_kses_post($tab_1_item['action']) == '2'): ?>
                            </tr>
                            <tr>
                                <td><div class="table-col1">
                                    <div class="lecture-txt">
                                    <?php print wp_kses_post($tab_1_item['name']); ?> 
                                    </div>
                                    <?php print wp_kses_post($tab_1_item['description']); ?> 
                                    </div>
                                </td> 
                            <?php endif; ?>
                            <?php endforeach; ?>
                        </tr>
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="tab-pane fade" role="tabpanel" id="schedule" aria-labelledby="schedule-tab">
                  <div class="table-responsive">
                    <table class="table course-table table-bordered">
                      <thead>
                        <tr>
                          <?php foreach ( $settings['tabs_2_column'] as $column2 ) : ?>
                            <th><?php print wp_kses_post($column2['name']); ?></th>
                            <?php endforeach; ?>
                        </tr>
                      </thead>
                      <tbody>
                        <?php foreach ( $settings['tabs_2_row'] as $tabs2_row ) : ?>
                        <tr>
                          <td><div class="table-col1"><?php print wp_kses_post($tabs2_row['fee']); ?> </div></td>
                          <td><div class="fee-amt"><?php print wp_kses_post($tabs2_row['amount']); ?></div>
                            <?php if(isset($tabs2_row['fee_detail']) && $tabs2_row['fee_detail'] != ''){?>
                            <ul class="fee-details"><?php print wp_kses_post($tabs2_row['fee_detail']); ?></ul>
                            <?php } ?>
                          </td>
                        </tr>
                        <?php endforeach; ?>
                      </tbody>
                    </table>
                  </div>
                </div>
                <div class="tab-pane fade" role="tabpanel" id="semester" aria-labelledby="semester-tab">
                    <div class="row">
                        <div class="col-sm-6">
                          <ul class="content">
                            <?php foreach ( $settings['tabs_3_column_1'] as $tab3_col1 ) : ?>
                            <li>
                              <h4><?php print wp_kses_post($tab3_col1['tab3_title']); ?></h4>
                              <p><?php print wp_kses_post($tab3_col1['content']); ?></p>
                            </li>
                            <?php endforeach; ?>
                        </div>
                        <div class="col-sm-6">
                          <ul class="content">
                            <?php foreach ( $settings['tabs_3_column_2'] as $tab3_col2 ) : ?>
                            <li>
                              <h4><?php print wp_kses_post($tab3_col2['tab3_title']); ?></h4>
                              <p><?php print wp_kses_post($tab3_col2['content']); ?></p>
                            </li>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" role="tabpanel" id="teachers" aria-labelledby="teachers-tab">
                    <ul class="row browse-teachers-list clearfix">
                        <?php foreach ( $settings['teachers'] as $teacher ) : ?>
                        <li class="col-xs-6 col-sm-3">
                            <figure> <img src="<?php echo wp_kses_post($teacher['team_image']['url']); ?>" alt="" width="123" height="124"> </figure>
                            <?php if(isset($teacher['team_name']) && $teacher['team_name'] != ''){?>
                            <h3><?php print wp_kses_post($teacher['team_name']); ?></h3>
                            <?php } ?>
                            <?php if(isset($teacher['job']) && $teacher['job'] != ''){?>
                            <span class="designation"><?php print wp_kses_post($teacher['job']); ?></span>
                            <?php } ?>
                            <?php if(isset($teacher['text']) && $teacher['text'] != ''){?>
                            <p class="equal-hight"><?php print wp_kses_post($teacher['text']); ?></p>
                            <?php } ?>
                            <ul class="teachers-follow">
                                <?php if(isset($teacher['link_social_1']) && $teacher['link_social_1'] != ''){?>
                                <li><a href="<?php print wp_kses_post($teacher['link_social_1']); ?>"><i class="<?php print wp_kses_post($teacher['social_1']); ?>" aria-hidden="true"></i></a></li>
                                <?php } ?>
                                <?php if(isset($teacher['link_social_2']) && $teacher['link_social_2'] != ''){?>
                                <li><a href="<?php print wp_kses_post($teacher['link_social_2']); ?>"><i class="<?php print wp_kses_post($teacher['social_2']); ?>" aria-hidden="true"></i></a></li>
                                <?php } ?>
                                <?php if(isset($teacher['link_social_3']) && $teacher['link_social_3'] != ''){?>
                                <li><a href="<?php print wp_kses_post($teacher['link_social_3']); ?>"><i class="<?php print wp_kses_post($teacher['social_3']); ?>" aria-hidden="true"></i></a></li>
                                <?php } ?>
                            </ul>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Course Details Tab --> 
    <?php
    }

}


